/*
 * Decompiled with CFR 0.152.
 */
package io.github.noeppi_noeppi.libx.render;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.noeppi_noeppi.libx.impl.RendererOnDataGenException;
import io.github.noeppi_noeppi.libx.util.LazyValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.commons.lang3.tuple.Pair;

public class ItemStackRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final LazyValue<ItemStackRenderer> INSTANCE = new LazyValue<ItemStackRenderer>(() -> new ItemStackRenderer(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));
    private static final List<BlockEntityType<?>> types = Collections.synchronizedList(new LinkedList());
    private static final Map<Block, Pair<LazyValue<BlockEntity>, Boolean>> blocks = Collections.synchronizedMap(new HashMap());
    private static final Map<BlockEntityType<?>, CompoundTag> defaultTags = new HashMap();

    public ItemStackRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
    }

    public static <T extends BlockEntity> void addRenderBlock(BlockEntityType<T> beType, boolean readBlockEntityTag) {
        types.add(beType);
        for (Block block : beType.f_58915_) {
            blocks.put(block, (Pair<LazyValue<BlockEntity>, Boolean>)Pair.of(new LazyValue<BlockEntity>(() -> beType.m_155264_(BlockPos.f_121853_, block.m_49966_())), (Object)readBlockEntityTag));
        }
    }

    public void m_108829_(ItemStack stack, @Nonnull ItemTransforms.TransformType type, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        Block block = Block.m_49814_((Item)stack.m_41720_());
        if (block != Blocks.f_50016_ && blocks.containsKey(block)) {
            Pair<LazyValue<BlockEntity>, Boolean> pair = blocks.get(block);
            BlockState state = block.m_49966_();
            BlockEntity blockEntity = (BlockEntity)((LazyValue)pair.getLeft()).get();
            BlockEntityType teType = blockEntity.m_58903_();
            BlockEntityRenderer renderer = this.f_172547_.m_112265_(blockEntity);
            if (renderer != null) {
                if (((Boolean)pair.getRight()).booleanValue()) {
                    if (!defaultTags.containsKey(teType)) {
                        ItemStackRenderer.setLevelAndState(blockEntity, state);
                        defaultTags.put(teType, blockEntity.m_187480_());
                    }
                    CompoundTag nbt = stack.m_41783_();
                    ItemStackRenderer.setLevelAndState(blockEntity, state);
                    blockEntity.m_142466_(defaultTags.get(teType));
                    if (nbt != null && nbt.m_128425_("BlockEntityTag", 10)) {
                        CompoundTag blockTag = nbt.m_128469_("BlockEntityTag");
                        blockEntity.m_142466_(blockTag);
                    }
                }
                if (Minecraft.m_91087_().f_91073_ != null) {
                    blockEntity.m_142339_((Level)Minecraft.m_91087_().f_91073_);
                }
                blockEntity.f_58856_ = state;
                poseStack.m_85836_();
                if (state.m_60799_() != RenderShape.ENTITYBLOCK_ANIMATED) {
                    Minecraft.m_91087_().m_91289_().m_110912_(block.m_49966_(), poseStack, buffer, light, overlay);
                }
                renderer.m_6922_(blockEntity, Minecraft.m_91087_().m_91296_(), poseStack, buffer, light, overlay);
                poseStack.m_85849_();
            }
        }
    }

    private static void setLevelAndState(BlockEntity blockEntity, BlockState state) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            blockEntity.m_142339_((Level)Minecraft.m_91087_().f_91073_);
        }
        blockEntity.f_58856_ = state;
    }

    public static ItemStackRenderer get() {
        if (FMLLoader.getLaunchHandler().isData()) {
            throw new RendererOnDataGenException();
        }
        return INSTANCE.get();
    }

    public static IItemRenderProperties createProperties() {
        return new IItemRenderProperties(){

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return ItemStackRenderer.get();
            }
        };
    }
}

